% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performanceassess.R
\name{iterations.check}
\alias{iterations.check}
\title{Performance assessment of iterative MCMC scheme against a known Bayesian network}
\usage{
iterations.check(MCMCmult, truedag, sample = FALSE, cpdag = TRUE,
  pbarrier = 0.5)
}
\arguments{
\item{MCMCmult}{an object which of class \code{MCMCmult}, contained in the output of the function \code{\link{iterativeMCMCsearch}}, when its \code{chainout} argument is set to TRUE; contains adjacency matrices sampled at each iteration of search space expansion; acessible by \code{MCMCout$chain}, where \code{MCMCout} is the output of function \code{\link{iterativeMCMCsearch}}}

\item{truedag}{ground truth DAG which generated the data used in the search procedure; represented by an object of class \code{\link[graph]{graphNEL}}}

\item{sample}{logical (FALSE by default), indicates if \code{MCMCmult} contains sample or maximum score DAGs}

\item{cpdag}{logical, if TRUE (FALSE by default) all DAGs in the \code{MCMCmult} are first converted to their respective equivalence class (CPDAG) before the averaging if parameter \code{sample} set to TRUE}

\item{pbarrier}{threshold such that only edges with a higher posterior probability will be retained in the directed graph summarising the sample of DAGs at each iteration from \code{MCMCmult} if parameter \code{sample} set to TRUE}
}
\value{
A matrix with the number of rows equal to the number of elements in \code{MCMCmult}, and 5 columns reporting for 
the maximally scoring DAG uncovered at each iteration (or for a summary over the sample of DAGs if \code{sample} parameter set to TRUE) 
the number of true positive edges (`TP'), the number of false positive edges (`FP'), 
the true positive rate (`TPR'), the structural Hamming distance (`SHD') and the score of the DAG (`SC'). 
Note that the maximum estimated DAG as well as the true DAG are first converted to 
the corresponding equivalence class (CPDAG) when calculating the SHD.
}
\description{
This function calculates the number of true and false positives, the true positive rate, the structural Hamming distance and score for each iteration in the search procedure implemented in the \code{\link{iterativeMCMCsearch}} function
}
\examples{
myDAG<-pcalg::randomDAG(20, prob=0.15, lB = 0.4, uB = 2) 
myData<-pcalg::rmvDAG(200, myDAG)
myScore<-scoreparameters(20, "bge", myData)
\dontrun{
MAPestimate<-iterativeMCMCsearch(20, myScore, chainout=TRUE, scoreout=TRUE)
iterations.check(MAPestimate$chain, myDAG)
}
}
