% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotfns.R
\name{plotpedges}
\alias{plotpedges}
\title{Plotting posterior probabilities of single edges}
\usage{
plotpedges(MCMCtrace, cutoff = 0.2, pdag = FALSE, onlyedges = NULL)
}
\arguments{
\item{MCMCtrace}{an object of class MCMCres}

\item{cutoff}{number representing a threshold of posterior probability below which lines will not be plotted}

\item{pdag}{logical, when true DAGs in a sample will be first coverted to CPDAGs}

\item{onlyedges}{(optional) binary matrix, only edges corresponding to entries whuch equal 1 will be plotted}
}
\value{
plots the graph which includes edges from edag and truedag, however edges which are different in edag compared to truedag are coloured according to the type of a mistake: false positive with red, false negative with dashed grey, error in direction with magenta
}
\description{
This function plots posterior probabilities of all possible edges in the graph as a function of MCMC iterations. It can be used for convergence diagnostics of MCMC
sampling algorithms order MCMC and partition MCMC.
}
\examples{
score100<-scoreparameters(8, "bde", Asia[1:100,])
orderfit100<-orderMCMC(score100,plus1=FALSE)
score5000<-scoreparameters(8, "bde", Asia)
orderfit5000<-orderMCMC(score5000,plus1=FALSE)
plotpedges(orderfit100)
plotpedges(orderfit5000)
}
