% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performanceassess.R
\name{iterations.check}
\alias{iterations.check}
\title{Performance assessment of iterative MCMC scheme against a known Bayesian network}
\usage{
iterations.check(MCMCmult, truedag, cpdag = TRUE, p = 0.5, trans = TRUE)
}
\arguments{
\item{MCMCmult}{an object which of class \code{MCMCmult} (output of the function \code{\link{iterativeMCMC}}, see also \code{\link{MCMCmult}})}

\item{truedag}{ground truth DAG which generated the data used in the search procedure; represented by an object of class \code{\link[graph]{graphNEL}}}

\item{cpdag}{logical, if TRUE (FALSE by default) all DAGs in the \code{MCMCmult} are first converted to their respective equivalence class (CPDAG) before the averaging if parameter \code{sample} set to TRUE}

\item{p}{threshold such that only edges with a higher posterior probability will be retained in the directed graph summarising the sample of DAGs at each iteration from \code{MCMCmult} if parameter \code{sample} set to TRUE}

\item{trans}{logical, for DBNs indicates if model comparions are performed for transition structure; when \code{trans} equals FALSE the comparison is performed for initial structures of estimated models and the ground truth DBN; for usual BNs the parameter is disregarded}
}
\value{
A matrix with the number of rows equal to the number of elements in \code{MCMCmult}, and 5 columns reporting for 
the maximally scoring DAG uncovered at each iteration (or for a summary over the sample of DAGs if \code{sample} parameter set to TRUE) 
the number of true positive edges (`TP'), the number of false positive edges (`FP'), 
the true positive rate (`TPR'), the structural Hamming distance (`SHD') and the score of the DAG (`score'). 
Note that the maximum estimated DAG as well as the true DAG are first converted to 
the corresponding equivalence class (CPDAG) when calculating the SHD.
}
\description{
This function calculates the number of true and false positives, the true positive rate, the structural Hamming distance and score for each iteration in the search procedure implemented in the function \code{\link{iterativeMCMC}}.
}
\examples{
gsim.score<-scoreparameters("bge", gsim)
\dontrun{
MAPestimate<-iterativeMCMC(gsim.score)
iterations.check(MAPestimate, gsimmat)
}
}
\author{
Polina Suter
}
