% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotfns.R
\name{plotpedges}
\alias{plotpedges}
\title{Plotting posterior probabilities of single edges}
\usage{
plotpedges(
  MCMCtrace,
  cutoff = 0.2,
  pdag = FALSE,
  onlyedges = NULL,
  highlight = NULL,
  ...
)
}
\arguments{
\item{MCMCtrace}{an object of class MCMCres}

\item{cutoff}{number representing a threshold of posterior probability below which lines will not be plotted}

\item{pdag}{logical, when true DAGs in a sample will be first coverted to CPDAGs}

\item{onlyedges}{(optional) binary matrix, only edges corresponding to entries which equal 1 will be plotted}

\item{highlight}{(optional) binary matrix, edges corresponding to entries which equal 1 are highlighted with "red"}

\item{...}{(optional) parameters passed to the plot function}
}
\value{
plots posterior probabilities of edges in the graph as a function of MCMC iterations
}
\description{
This function plots posterior probabilities of all possible edges in the graph as a function of MCMC iterations. It can be used for convergence diagnostics of MCMC
sampling algorithms order MCMC and partition MCMC.
}
\examples{
score100<-scoreparameters("bde", Asia[1:100,])
orderfit100<-orderMCMC(score100,plus1=TRUE,chainout=TRUE)
\dontrun{
score5000<-scoreparameters("bde", Asia)
orderfit5000<-orderMCMC(score5000,plus1=TRUE,chainout=TRUE)
plotpedges(orderfit100, pdag=TRUE)
plotpedges(orderfit5000, pdag=TRUE)
}
}
\author{
Polina Suter
}
