% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/showDistanceToTarget.R
\name{showDistanceToTarget}
\alias{showDistanceToTarget}
\title{Visualizes the distance to the target in a plot.}
\usage{
showDistanceToTarget(obj, ...)
}
\arguments{
\item{obj}{An object that must contain at least three elements:
distance:A numeric vector representing the distance to the target
targetRadious: A numeric value indicating the target radius.
r:An object containing at least two elements:
  - start: A numeric value representing the start of the range.
  - length: A numeric value representing the length of the range.}

\item{...}{Additional parameters of object.}
}
\value{
A plot showing the relationship between the object's position and the target's position.
}
\description{
This function generates a plot of the distance to a target over time or some other 
associated parameter in the object. It also draws a horizontal line to indicate 
the target radius and a red segment that shows the start and length of a parameter 
associated with the `obj`.
}
\details{
This function generates a line plot of the distance to a target (stored in `obj$distance`). 
It also draws a red horizontal line at the value of `obj$targetRadious` to indicate the 
target's radius. Additionally, a red vertical segment is drawn to show the start of the range 
defined by `obj$r$start` and the length defined by `obj$r$length`.
}
\examples{
# Create a fictional object with example data
obj <- list(
  distance = rep(c(5, 10, 15, 20, 15, 10, 5),5),
  targetRadious = 12,
  r = list(start = 2, length = 10)
)
# Visualize the distance to the target using the function
showDistanceToTarget(obj)

}
