% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdd_plot.R
\name{cdd_plot}
\alias{cdd_plot}
\title{cdd_plot}
\usage{
cdd_plot(
  cdd_file,
  fasta_file,
  the_order = NULL,
  domain_select = NULL,
  shape = "RoundRect",
  r = 0.3,
  legend_size = 15,
  domain_color = NULL
)
}
\arguments{
\item{cdd_file}{The path of cdd file.}

\item{fasta_file}{The path of fasta file.}

\item{the_order}{The path of order file. A List of Gene ID , One ID Per Line.}

\item{domain_select}{The domain ID which you want to align with.}

\item{shape}{RoundRect or Rect.}

\item{r}{The radius of rounded corners.}

\item{legend_size}{The size of legend.}

\item{domain_color}{The color set of domain.}
}
\value{
p
}
\description{
Visualization of domain in CDD file
}
\examples{
hitdata_path <- system.file("extdata", "hitdata.txt", package = "BioVizSeq")
fa_path <- system.file("extdata", "idpep.fa", package = "BioVizSeq")
cdd_plot(hitdata_path, fa_path)

order_path <- system.file("extdata", "order.csv", package = "BioVizSeq")
cdd_plot(hitdata_path, fa_path, the_order = order_path)
}
\author{
Shiqi Zhao
}
