% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/categorical_boundary.R
\name{categorical_boundary}
\alias{categorical_boundary}
\title{Define the boundary elements of a SpatRaster with categorical data}
\usage{
categorical_boundary(x)
}
\arguments{
\item{x}{A SpatRaster object.}
}
\value{
A SpatRaster object with cell values 1 for boundary elements and 0 for other cells
}
\description{
Creates boundary element cells where patches of two categories meet.
}
\examples{
\donttest{
data(grassland)
grassland <- terra::rast(grassland_matrix, crs = grassland_crs)
terra::ext(grassland) <- grassland_ext

grassland_boundaries <- categorical_boundary(grassland)
}

}
\author{
Amy Luo
}
