% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Main.R
\name{Buddle_Predict}
\alias{Buddle_Predict}
\title{Making a prediction based on the traind network model obtained from Buddle_Main()}
\usage{
Buddle_Predict(lst, xVec)
}
\arguments{
\item{lst}{- Feed-forward neural network model}

\item{xVec}{- Vector of data}
}
\value{
Predicted classification for given data. 
####################
}
\description{
Making a prediction based on the traind network model obtained from Buddle_Main()
}
\examples{
n = 50
p = 3
Data = matrix(runif(n*p, 0,50), nrow=n, ncol=p)  #### Generate n-by-p input matrix for data
Label = sample.int(n, n, replace=TRUE)            #### Generate n-by-1 vector for the label
DLResult = Buddle_Main(Data, Label, 20, 5, "SGD", 0.01, 100, 6, 20, "Sigmoid")

xVec=rep(0, times=p)
Index = Buddle_Predict(DLResult, xVec)        ###### Predict for given xVec

}
\references{
[1] Geron, A. Hand-On Machine Learning with Scikit-Learn and TensorFlow. Sebastopol: O'Reilly, 2017. Print.

[2] Han, J., Pei, J, Kamber, M. Data Mining: Concepts and Techniques. New York: Elsevier, 2011. Print.
}
\seealso{
Buddle_Main
}
