% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discreteRoot.R
\name{discreteRoot}
\alias{discreteRoot}
\title{Dichotomic search for monotone function}
\usage{
discreteRoot(
  fn,
  grid,
  increasing = TRUE,
  check = TRUE,
  tol = .Machine$double.eps^0.5
)
}
\arguments{
\item{fn}{[function] objective function to minimize in absolute value.}

\item{grid}{[vector] possible minimizers.}

\item{increasing}{[logical] is the function fn increasing?}

\item{check}{[logical] should the program check that fn takes a different sign for the first vs. the last value of the grid?}

\item{tol}{[numeric] the absolute convergence tolerance.}
}
\description{
Find the root of a monotone function on a discrete grid of value using dichotomic search
}
\author{
Brice Ozenne
}
