% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerBuyseTest.R
\name{powerBuyseTest}
\alias{powerBuyseTest}
\title{Performing simulation studies with BuyseTest}
\usage{
powerBuyseTest(
  sim,
  sample.size,
  sample.sizeC = NULL,
  sample.sizeT = NULL,
  n.rep,
  null = c(netBenefit = 0),
  cpus = 1,
  seed = NULL,
  conf.level = NULL,
  alternative = NULL,
  order.Hprojection = NULL,
  transformation = NULL,
  trace = 1,
  ...
)
}
\arguments{
\item{sim}{[function] take two arguments:
the sample size in the control group (\code{n.C}) and the sample size in the treatment group (\code{n.C})
and generate datasets. The datasets must be data.table objects.}

\item{sample.size}{[integer vector, >0] the various sample sizes at which the simulation should be perform.
Disregarded if any of the arguments \code{sample.sizeC} or \code{sample.sizeT} are specified.}

\item{sample.sizeC}{[integer vector, >0] the various sample sizes in the control group.}

\item{sample.sizeT}{[integer vector, >0] the various sample sizes in the treatment group.}

\item{n.rep}{[integer, >0] the number of simulations.}

\item{null}{[numeric vector] For each statistic of interest, the null hypothesis to be tested.
The vector should be named with the names of the statistics.}

\item{cpus}{[integer, >0] the number of CPU to use. Default value is 1.}

\item{seed}{[integer, >0] the seed to consider for the simulation study.}

\item{conf.level}{[numeric] confidence level for the confidence intervals.
Default value read from \code{BuyseTest.options()}.}

\item{alternative}{[character] the type of alternative hypothesis: \code{"two.sided"}, \code{"greater"}, or \code{"less"}.
Default value read from \code{BuyseTest.options()}.}

\item{order.Hprojection}{[integer 1,2] the order of the H-project to be used to compute the variance of the net benefit/win ratio.
Default value read from \code{BuyseTest.options()}.}

\item{transformation}{[logical] should the CI be computed on the logit scale / log scale for the net benefit / win ratio and backtransformed.
Otherwise they are computed without any transformation.
Default value read from \code{BuyseTest.options()}.}

\item{trace}{[integer] should the execution of the function be traced?}

\item{...}{other arguments (e.g. \code{scoring.rule}, \code{method.inference}) to be passed to \code{initializeArgs}.}
}
\description{
Performs a simulation studies for several sample sizes.
Returns estimates, standard errors, confidence intervals and p.values.
}
\examples{
library(data.table)

#### Using simBuyseTest ####
## only point estimate
powerBuyseTest(sim = simBuyseTest, sample.size = c(10, 50, 100), n.rep = 10,
               formula = treatment ~ bin(toxicity), seed = 10,
               method.inference = "none", trace = 2)

## point estimate with rejection rate
powerBuyseTest(sim = simBuyseTest, sample.size = c(10, 50, 100), n.rep = 10,
               formula = treatment ~ bin(toxicity), seed = 10,
               method.inference = "u-statistic", trace = 4)

#### Using user defined simulation function ####
## Example of power calculation for Wilcoxon test
simFCT <- function(n.C, n.T){
    out <- rbind(cbind(Y=stats::rt(n.C, df = 5), group=0),
                 cbind(Y=stats::rt(n.T, df = 5), group=1) + 1)
    return(data.table::as.data.table(out))
}

\dontshow{
powerW <- powerBuyseTest(sim = simFCT, sample.size = c(5, 10,20,30,50,100),
                         n.rep = 10, formula = group ~ cont(Y))
summary(powerW)
}
\dontrun{
powerW <- powerBuyseTest(sim = simFCT, sample.size = c(5, 10,20,30,50,100),
                         n.rep = 1000, formula = group ~ cont(Y), cpus = "all")
summary(powerW)
} 

}
\author{
Brice Ozenne
}
