% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4-BuysePower-model.tables.R
\docType{methods}
\name{S4BuysePower-model.tables}
\alias{S4BuysePower-model.tables}
\alias{model.tables,S4BuysePower-method}
\title{Extract Summary for Class "S4BuysePower"}
\usage{
\S4method{model.tables}{S4BuysePower}(
  x,
  type = "summary",
  statistic = NULL,
  endpoint = NULL,
  order.Hprojection = NULL,
  transformation = NULL
)
}
\arguments{
\item{x}{output of \code{\link{powerBuyseTest}}}

\item{type}{[character] should a summary of the results (\code{"summary"}) or the raw results (\code{"raw"}) be output?}

\item{statistic}{[character] statistic relative to which the power should be computed:
\code{"netBenefit"} displays the net benefit, as described in Buyse (2010) and Peron et al. (2016)),
\code{"winRatio"} displays the win ratio, as described in Wang et al. (2016),
\code{"mannWhitney"} displays the proportion in favor of the treatment (also called Mann-Whitney parameter), as described in Fay et al. (2018).
Default value read from \code{BuyseTest.options()}.}

\item{endpoint}{[character vector] the endpoints to be displayed: must be the name of the endpoint followed by an underscore and then by the threshold.}

\item{order.Hprojection}{[integer 1,2] the order of the H-project to be used to compute the variance of the net benefit/win ratio.}

\item{transformation}{[logical] should the CI be computed on the logit scale / log scale for the net benefit / win ratio and backtransformed.}
}
\value{
data.frame
}
\description{
Extract a summary of the results from the \code{\link{powerBuyseTest}} function.
}
\seealso{
\code{\link{powerBuyseTest}} for performing a simulation study for generalized pairwise comparison. \cr
}
\author{
Brice Ozenne
}
\keyword{methods}
