/*
 * Decompiled with CFR 0.152.
 */
package org.neptuneinc.cadstat.plots;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.neptuneinc.cadstat.plots.SpringUtilities;
import org.rosuda.JGR.JGR;

public class BiologicalInferencesTaxaNameUnrecog
extends JFrame
implements ListSelectionListener,
DocumentListener {
    private JLabel title;
    private JButton okButton;
    private JButton cancelButton;
    private JPanel taxaNamePanel;
    private JScrollPane taxaNameScrollPane;
    private JLabel[] taxaNameOrigLabel;
    private JTextField[] taxaNameCorrTextField;
    private int numOfTaxa;
    private String[] taxaName;

    public BiologicalInferencesTaxaNameUnrecog() {
    }

    public BiologicalInferencesTaxaNameUnrecog(int num, String str) {
        this.numOfTaxa = num;
        this.taxaName = new String[this.numOfTaxa];
        this.taxaName[0] = str;
        this.initComponents();
    }

    public BiologicalInferencesTaxaNameUnrecog(int num, String[] str) {
        this.numOfTaxa = num;
        this.taxaName = new String[this.numOfTaxa];
        this.taxaName = str;
        this.initComponents();
    }

    private void initComponents() {
        int i;
        this.taxaNameOrigLabel = new JLabel[this.numOfTaxa];
        this.taxaNameCorrTextField = new JTextField[this.numOfTaxa];
        for (i = 0; i < this.numOfTaxa; ++i) {
            this.taxaNameOrigLabel[i] = new JLabel();
            this.taxaNameCorrTextField[i] = new JTextField(20);
        }
        for (i = 0; i < this.numOfTaxa; ++i) {
            this.taxaNameOrigLabel[i].setText(this.taxaName[i]);
            this.taxaNameCorrTextField[i].setText(this.taxaName[i]);
        }
        this.title = new JLabel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.taxaNamePanel = new JPanel();
        this.taxaNameScrollPane = new JScrollPane();
        this.title.setFont(new Font("Tahoma", 0, 13));
        this.title.setText("Please correct the following unrecognized taxon names (changes will not be saved in original data):");
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BiologicalInferencesTaxaNameUnrecog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BiologicalInferencesTaxaNameUnrecog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.setLocation(200, 200);
        this.setDefaultCloseOperation(2);
        this.setTitle("Biological Inferences");
        SpringLayout taxaNamePanelLayout = new SpringLayout();
        this.taxaNamePanel.setLayout(taxaNamePanelLayout);
        for (int i2 = 0; i2 < this.numOfTaxa; ++i2) {
            this.taxaNamePanel.add(this.taxaNameOrigLabel[i2]);
            this.taxaNamePanel.add(this.taxaNameCorrTextField[i2]);
        }
        SpringUtilities.makeCompactGrid(this.taxaNamePanel, this.numOfTaxa, 2, 6, 6, 6, 6);
        int preferredHigh = this.numOfTaxa < 12 ? this.numOfTaxa * 25 + 30 : 300;
        this.taxaNameScrollPane = new JScrollPane(this.taxaNamePanel);
        this.taxaNameScrollPane.setVerticalScrollBarPolicy(20);
        this.taxaNameScrollPane.setPreferredSize(new Dimension(400, preferredHigh));
        this.taxaNameScrollPane.setHorizontalScrollBarPolicy(30);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(74, 74, 74).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.taxaNameScrollPane, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.okButton).addGap(52, 52, 52).addComponent(this.cancelButton)).addComponent(this.title)).addGap(80, 80, 80)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(25, 25, 25).addComponent(this.title).addGap(18, 18, 18).addComponent(this.taxaNameScrollPane, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap(71, Short.MAX_VALUE)));
        this.pack();
    }

    private JFrame getMyGUI(int num, String str) {
        BiologicalInferencesTaxaNameUnrecog jf = new BiologicalInferencesTaxaNameUnrecog(num, str);
        jf.setVisible(true);
        return jf;
    }

    private JFrame getMyGUI(int num, String[] str) {
        BiologicalInferencesTaxaNameUnrecog jf = new BiologicalInferencesTaxaNameUnrecog(num, str);
        jf.setVisible(true);
        return jf;
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        int j = 0;
        for (int i = 0; i < this.numOfTaxa; ++i) {
            if (this.taxaNameCorrTextField[i].getText().length() != 0) continue;
            ++j;
        }
        if (j > 0) {
            System.out.println("No empty taxa name allowed");
            JOptionPane.showMessageDialog(null, "Empty taxa name aren't allowed! Unrecognized taxa will be ignored");
        } else {
            System.out.println("OK buttom is pushed");
            String str = "";
            for (int i = 0; i < this.numOfTaxa; ++i) {
                str = i == this.numOfTaxa - 1 ? str + "\"" + this.taxaNameCorrTextField[i].getText() + "\"" : str + "\"" + this.taxaNameCorrTextField[i].getText() + "\"" + ",";
            }
            String cmd = "bioinfer.JGR(tname.new=c(" + str + "))";
            JGR.MAINRCONSOLE.execute(cmd, true);
            this.dispose();
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

