% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_nreps.R
\name{plot.nreps}
\alias{plot.nreps}
\title{plot.nreps}
\usage{
\method{plot}{nreps}(
  x,
  y = NULL,
  ...,
  instance.name = NULL,
  latex = FALSE,
  show.SE = TRUE,
  show.CI = TRUE,
  sig.level = 0.05,
  show.text = TRUE
)
}
\arguments{
\item{x}{list object of class \emph{nreps} (generated by \code{\link[=calc_nreps]{calc_nreps()}})
or of class \emph{CAISEr} (in which case an \code{instance.name}
must be provided).}

\item{y}{unused. Included for consistency with generic \code{plot} method.}

\item{...}{other parameters to be passed down to specific
plotting functions (currently unused)}

\item{instance.name}{name for instance to be plotted if \code{object} is
of class \emph{CAISEr}. Ignored otherwise.}

\item{latex}{logical: should labels be formatted for LaTeX? (useful for
later saving using library \code{TikzDevice})}

\item{show.SE}{logical: should standard errors be plotted?}

\item{show.CI}{logical: should confidence intervals be plotted?}

\item{sig.level}{significance level for the confidence interval.
0 < sig.level < 1}

\item{show.text}{logical: should text be plotted?}
}
\value{
\code{ggplot} object (invisibly)
}
\description{
S3 method for plotting \emph{nreps} objects output by \code{\link[=calc_nreps]{calc_nreps()}}).
}
