\name{CARBayes-package}
\alias{CARBayes-package}
\alias{CARBayes}
\docType{package}

\title{
Spatial Areal Unit Modelling
}


\description{
Implements a class of spatial generalised linear mixed models for areal unit data, 
with inference in a Bayesian setting using Markov chain Monte Carlo (McMC) 
simulation. The spatial autocorrelation is modelled by  a set of random effects, 
which are assigned a conditional autoregressive (CAR) prior distribution. A 
number of different CAR priors are available for the random effects, and full 
details are given in the vignette accompanying this package. The initial creation 
of this package was supported by the Economic and Social Research Council (ESRC) 
grant RES-000-22-4256, and on-going development is supported by the Engineering 
and Physical Science Research Council (EPSRC) grant EP/J017442/1.
}

\details{
\tabular{ll}{
Package: \tab CARBayes\cr
Type: \tab Package\cr
Version: \tab 4.1\cr
Date: \tab 2015-04-01\cr
License: \tab GPL (>= 2)\cr
}

The response variable for the class of generalised linear mixed models implmented
here can be binomial, Gaussian or Poisson, and the mean function comprises  
covariates and a set of random effects. A number of different prior distributions
are available for the random effects, which represent different types of spatial 
autocorrelation. These prior models are from the class of conditional autoregressive 
(CAR) models, which capture spatial autocorrelation via a neighbourhood matrix W. 
This matrix is typically binary(although non-binary matrices are allowed) and has
a jkth element equal to one or zero, depending on whether areas j and k are 
spatially close (typically chosen to mean sharing a common border). The following 
random effects prior models are implemented in this package.

An independent and identically distributed Gaussian prior.

The intrinsic autoregressive (IAR) model proposed by Besag et al. (1991).

The Besag-York-Mollie (BYM) model proposed by Besag et al. (1991).

The proper CAR model proposed by Leroux et al. (1999).

The localised CAR model proposed by Lee and Mitchell (2012).

The localised CAR model proposed by Lee and Sarran (2014).

More detailed descriptions of the methods are given by the references below and
in the vignette accompanying this package. 
}




\author{
Maintainer: Duncan Lee <Duncan.Lee@glasgow.ac.uk>
}


\references{
Besag, J. and  York, J and Mollie, A (1991). Bayesian image restoration with two 
applications in spatial statistics. Annals of the Institute of Statistics and 
Mathematics 43, 1-59.

Lee, D. and Mitchell, R (2012). Boundary detection in disease mapping studies. 
Biostatistics, 13, 415-426.

Lee, D and Sarran, C  (2014). Controlling for unmeasured confounding and spatial 
misalignment in long-term air pollution and health studies. arXiv:1412.4479.

Leroux, B., Lei, X and Breslow, N (1999). Estimation of disease rates in small 
areas: A new mixed model for spatial dependence, Chapter Statistical Models in 
Epidemiology, the Environment and Clinical Trials, Halloran, M and Berry, D (eds), 
pp. 135-178. Springer-Verlag, New York.
}



\examples{
## See the examples in the function specific help files and in the vignette
## accompanying this package.
}
