#' Gut microbiota in the Irish Elderly
#'
#' This study is based on pyrosequencing of 16S rDNA amplicons from faecal samples collected from 178 elderly Irish citizens and 13 healthy young control subjects. A subset of these samples were also subjected to shotgun sequencing using Illumina HiSeq 2000 2x91bp reads. Antibiotic treatment was an exclusion criterion.
#'
#' @docType data
#'
#' @usage data(mgp154)
#'
#' @format An data.frame with genus and predictors.
#'
#' @keywords datasets
#'
#' @references Claesson, Marcus J., et al. "Gut microbiota composition correlates with diet and health in the elderly." Nature 488.7410 (2012): 178-184.
#'
#' @source \href{https://www.mg-rast.org/mgmain.html?mgpage=project&project=mgp154}{MG-RAST-mgp154}
#'
"mgp154"



#' Hofmockel Soil Aggregate COB KBASE
#'
#' This study is to examine soil microbial community composition and structure of both bacteria and fungi at a microbially-relevant scale. The researchers isolated soil aggregates from three land management systems in central Iowa to test if the aggregate-level microbial responses are related to plant community and management practices. The clean dataset has 120 samples with 17 genus under consideration.
#'
#' @docType data
#'
#' @usage data(mgp2592)
#'
#' @format An data.frame with genus and predictors.
#'
#' @keywords datasets
#'
#' @references Bach, Elizabeth M., et al. "Greatest soil microbial diversity found in micro-habitats." Soil biology and Biochemistry 118 (2018): 217-226.
#'
#' @source \href{https://www.mg-rast.org/mgmain.html?mgpage=project&project=mgp2592}{MG-RAST-mgp2592}
#'
"mgp2592"