% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rCARlasso_}
\alias{rCARlasso_}
\title{Block Gibbs sampler for CAR-LASSO}
\usage{
rCARlasso_(
  Z_curr,
  design,
  lambda2_beta,
  tau2_curr,
  beta_curr,
  lambda_Omega,
  Omega_curr,
  mu_curr,
  r_beta,
  delta_beta,
  r_Omega,
  delta_Omega,
  k,
  p,
  n
)
}
\arguments{
\item{Z_curr}{the current (latent) normal data, should be n*k. Will not be changed}

\item{design}{the design matrix, should be n*p. Will not be changed}

\item{lambda2_beta}{the current shrinkage parameter of regression coefficients, should be a scalar of type \code{double}. Will be updated}

\item{tau2_curr}{the current latent scale parameter in the normal mixture representation of Laplace, for regression coefficients, should be a vector with p*k entries. Will be updated.}

\item{beta_curr}{the current regression coefficients, should be a matrix sized p*k (p row and k columns). Will be updated.}

\item{lambda_Omega}{the current shrinkage parameter for Omega, should be a scalar of tyoe \code{double}. Will be updated.}

\item{Omega_curr}{the current Omega matrix, should be a matrix of size k*k. Will be updated.}

\item{mu_curr}{the current mu, intercept, should be a vector of size k. Will be updated.}

\item{r_beta}{hyperprior's parameter of shrinkage for regression coefficients, should be a scalar of type 'double' and positive. Will not be updated.}

\item{delta_beta}{hyperprior's parameter of shrinkage for regression coefficients, should be a scalar of type 'double' and positive. Will not be updated.}

\item{r_Omega}{hyperprior's parameter of shrinkage for precision Omega, should be a scalar of type 'double' and positive. Will not be updated.}

\item{delta_Omega}{hyperprior's parameter of shrinkage for rprecision Omega, should be a scalar of type 'double' and positive. Will not be updated.}

\item{k}{integer, number of responses}

\item{p}{integer, number of predictors}

\item{n}{integer, number of data points}
}
\value{
Again this is a \code{void} function and will not return anything. All update happened in memory directly.
}
\description{
\strong{This function is for advanced users to build their own sampler use CARlasso as core.} It will execute one round of Gibbs sampler of CAR-LASSO model. Be aware that the function is a \code{void} function implemented in C++, and all updated parameters e.g. Omega will be manipulate directly in memory to save space. Users should manage to do their own work to save the state. Also be aware that R uses shallow copy by default, which means one cannot save the state by simply give it to another object e.g. first \code{Omega_old <- Omega_curr} then update \code{Omega_curr}, \code{Omega_old} will also change. \strong{This function will NOT check dimensions of input.} Below we assume n samples, k responses and p predictors.
}
