% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ADMM.R
\name{ADMM}
\alias{ADMM}
\title{Penalized Optimization Framework for Community Detection in Networks with Covariates.}
\usage{
ADMM(
  Adj,
  Covariate,
  lambda,
  K,
  alpha,
  rho,
  TT,
  tol,
  quiet = NULL,
  report_interval = NULL,
  r = NULL
)
}
\arguments{
\item{Adj}{A 0/1 adjacency matrix.}

\item{Covariate}{A covariate matrix. The rows correspond to nodes and the columns correspond to covariates.}

\item{lambda}{A tuning parameter to weigh the covariate matrix.}

\item{K}{A positive integer, indicating the number of underlying communities in graph \code{Adj}.}

\item{alpha}{A number. The elementwise upper bound in the SDP.}

\item{rho}{The learning rate of ADMM.}

\item{TT}{The maximum of iteration.}

\item{tol}{The tolerance for stopping criterion.}

\item{quiet}{An optional inoput. Whether to print result at each step.}

\item{report_interval}{An optional inoput. The frequency to print intermediate result.}

\item{r}{An optional inoput. The expected rank of the solution, leave NULL if no constraint is required.}
}
\value{
\item{estall}{A lavel vector.}
}
\description{
Semidefinite programming for optimizing the inner product between combined network and the
  solution matrix.
}
\details{
\emph{ADMM} is proposed in \emph{Covariate Regularized Community Detection in Sparse Graphs}
  of Yan & Sarkar (2021). \emph{ADMM} relies on semidefinite programming (SDP) relaxations for detecting
  the community structure in sparse networks with covariates.
}
\examples{

# Simulate the Network
n = 10; K = 2;
theta = 0.4 + (0.45-0.05)*(seq(1:n)/n)^2; Theta = diag(theta);
P  = matrix(c(0.8, 0.2, 0.2, 0.8), byrow = TRUE, nrow = K)
set.seed(2022)
l = sample(1:K, n, replace=TRUE); # node labels
Pi = matrix(0, n, K) # label matrix
for (k in 1:K){
  Pi[l == k, k] = 1
}
Omega = Theta \%*\% Pi \%*\% P \%*\% t(Pi) \%*\% Theta;
Adj = matrix(runif(n*n, 0, 1), nrow = n);
Adj = Omega - Adj;
Adj = 1*(Adj >= 0)
diag(Adj) = 0
Adj[lower.tri(Adj)] = t(Adj)[lower.tri(Adj)]
caseno = 4; Nrange = 10; Nmin = 10; prob1 = 0.9; p = n*4;
Q = matrix(runif(p*K, 0, 1), nrow = p, ncol = K)
Q = sweep(Q,2,colSums(Q),`/`)
W = matrix(0, nrow = n, ncol = K);
for(jj in 1:n) {
  if(runif(1) <= prob1) {W[jj, 1:K] = Pi[jj, ];}
  else W[jj, sample(K, 1)] = 1;
}
W = t(W)
D0 = Q \%*\% W
X = matrix(0, n, p)
N = switch(caseno, rep(100, n), rep(100, n), round(runif(n)*Nrange+ Nmin),
  round(runif(n)* Nrange+Nmin))
for (i in 1: ncol(D0)){
  X[i, ] = rmultinom(1, N[i], D0[, i])
}
ADMM(Adj, X, lambda = 0.2, K = K, alpha = 0.5, rho = 2, TT = 100, tol = 5)
}
\references{
Yan, B., & Sarkar, P. (2021). \emph{Covariate Regularized Community Detection in Sparse Graphs}.
  \emph{Journal of the American Statistical Association, 116(534), 734-745}.
  \cr\doi{10.1080/01621459.2019.1706541}\cr
}
