% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ffs.R
\name{plot_ffs}
\alias{plot_ffs}
\title{Plot results of a Forward feature selection or best subset selection}
\usage{
plot_ffs(
  ffs_model,
  plotType = "all",
  palette = rainbow,
  reverse = FALSE,
  marker = "black",
  size = 1.5,
  lwd = 0.5,
  pch = 21,
  ...
)
}
\arguments{
\item{ffs_model}{Result of a forward feature selection see \code{\link{ffs}}}

\item{plotType}{character. Either "all" or "selected"}

\item{palette}{A color palette}

\item{reverse}{Character. Should the palette be reversed?}

\item{marker}{Character. Color to mark the best models}

\item{size}{Numeric. Size of the points}

\item{lwd}{Numeric. Width of the error bars}

\item{pch}{Numeric. Type of point marking the best models}

\item{...}{Further arguments for base plot if type="selected"}
}
\description{
plot_ffs() is deprecated and will be removed soon. Please use generic plot() function on ffs object.
A plotting function for a forward feature selection result.
Each point is the mean performance of a model run. Error bars represent
the standard errors from cross validation.
Marked points show the best model from each number of variables until a further variable
could not improve the results.
If type=="selected", the contribution of the selected variables to the model
performance is shown.
}
\examples{
\dontrun{
data(iris)
ffsmodel <- ffs(iris[,1:4],iris$Species)
plot(ffsmodel)
#plot performance of selected variables only:
plot(ffsmodel,plotType="selected")
}
}
\seealso{
\code{\link{ffs}}, \code{\link{bss}}
}
\author{
Marvin Ludwig and Hanna Meyer
}
