% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyseTS.R
\name{analyseTS}
\alias{analyseTS}
\title{analyseTS}
\usage{
analyseTS(x, y, out.plot = NULL)
}
\arguments{
\item{x}{Object of class \emph{data.frame}.}

\item{y}{Vector of class \emph{character} or \emph{numeric} with a length equal to the number of rows in \emph{x}.}

\item{out.plot}{Specifies the data path where plots should be stored.}
}
\value{
A \emph{SpatialPointsDataDrame} with the coordinate pairs for each of the sampled pixels.
}
\description{
Summarizes multi-band \emph{raster} data within each element of a \emph{SpatialPolygons} object.
}
\details{
{For each unique value in \emph{y}, the function will select the rows in \emph{x} that correspond to it and estimate the
median, Median Absolute Deviation (MAD), minimum, maximum, mean and standard deviation for each column. Then, the function will build
a plot showing the median and draw a buffer that expresses the minimum and maximum. The final output is a list consisting of:
\itemize{
 \item{\emph{y.statistics} - Median, minimum and maximum values for each column in \emph{x} over each unique class in \emph{y}.}
 \item{\emph{plots} - List of line plots for each unique element in \emph{y}.}}
 If \emph{out.plot} is set, the function will save each plot as 10x10 cm PNG files within the specified path.
 }
}
\examples{
{

require(raster)
require(fieldRS)

# read raster data
r <- brick(system.file("extdata", "ndvi.tif", package="fieldRS"))

# read field data
data(fieldData)
data(fieldDataTS)

a.ts <- analyseTS(as.data.frame(fieldDataTS$weighted.mean), fieldData$crop)

}
}
\seealso{
\code{\link{extractTS}} \code{\link{phenoCropVal}} \code{\link{phenoCropClass}}
}
