% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_col.R
\name{add_col}
\alias{add_col}
\title{Add colors}
\usage{
add_col(var, cuts = 100, cols = c("green", "yellow", "red"))
}
\arguments{
\item{var}{numeric vector of the variable to be colorized. Either all values (in which case all
values will be assigned to a color) or only two values (in which case these are considered to be
the range of values).}

\item{cuts}{numeric, controls color classes. Either one value (in which case \code{cuts} equally
spaced color classes are generated) or a vector (in which cases irregular color classes are
generated e.g. \code{c(-10,0,100,2000)}).}

\item{cols}{character vector of colors (see R standard color names \href{http://www.stat.columbia.edu/~tzheng/files/Rcolor.pdf}{here}).
\code{cols} are interpolated along \code{cuts}. Color codes as such generated,
for example, by \code{\link[grDevices]{rgb}} may also be used.}
}
\value{
list containing the colors for the variable \code{var} (given as \code{$varcol} in the output) as
well as the single \code{cols} and \code{cuts}, to be used as inputs in \code{\link{add_Cscale}}.
}
\description{
Given an input variable, generates either a continuous color gradient or color classes.
To be used in conjunction with \code{\link{add_Cscale}}.
}
\examples{

#Example 1: add color to points

MyPoints=create_Points(PointData)
MyCols=add_col(MyPoints$Nfishes) #With default cols and cuts
plot(MyPoints,pch=21,bg=MyCols$varcol,cex=2)

MyCols=add_col(MyPoints$Nfishes,cols=c('blue','red')) #With custom colors - here from blue to red
plot(MyPoints,pch=21,bg=MyCols$varcol,cex=2)

MyCols=add_col(MyPoints$Nfishes,cols=c('blue','red'),cuts=3) #With custom colors and fewer classes
plot(MyPoints,pch=21,bg=MyCols$varcol,cex=2)

#Example 2: add color to a grid, using custom cuts and colors, and adding a color scale (add_Cscale)

#Step 1: Generate your grid
MyGrid=create_PolyGrids(GridData,dlon=2,dlat=1)

#Step 2: Inspect your grid data (e.g. sum of Catch) to determine whether irregular cuts are required
hist(MyGrid$Catch_sum,100) 
#In this case (heterogeneously distributed data) irregular cuts would be preferable

#Step 3: Generate colors according to the desired classes (cuts)
Gridcol=add_col(MyGrid$Catch_sum,cuts=c(0,50,100,500,2000,3500),cols=c('yellow','purple'))

#Step 4: Plot result and add color scale
Mypar=par(mai=c(0,0,0,2)) #Figure margins as c(bottom, left, top, right)
plot(MyGrid,col=Gridcol$varcol) #Use the colors generated by add_col
#Add color scale using cuts and cols generated by add_col
add_Cscale(title='Sum of Catch (t)',cuts=Gridcol$cuts,cols=Gridcol$cols,width=33) 
par(Mypar)

}
\seealso{
\code{\link{add_Cscale}}, \code{\link{create_PolyGrids}}, \href{http://www.stat.columbia.edu/~tzheng/files/Rcolor.pdf}{R colors}.
}
