% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{create_Points}
\alias{create_Points}
\title{Create Points}
\usage{
create_Points(
  Input,
  OutputFormat = "ROBJECT",
  OutputName = NULL,
  Buffer = 0,
  Clip = FALSE,
  SeparateBuf = TRUE,
  NamesIn = NULL
)
}
\arguments{
\item{Input}{the name of the \code{Input} data as a .csv file or an R dataframe.
If a .csv file is used as input, this file must be in your working directory and its name given in quotes
e.g. "DataFile.csv".

\strong{If \code{NamesIn} is not provided, the columns in the \code{Input} must be in the following order:

Latitude, Longitude, Variable 1, Variable 2, ... Variable x}}

\item{OutputFormat}{can be an R object or an ESRI Shapefile. if \code{OutputFormat} is specified as
"ROBJECT" (the default), a spatial object is created in your R environment.
if \code{OutputFormat} is specified as "SHAPEFILE", an ESRI Shapefile is exported in
your working directory.}

\item{OutputName}{if \code{OutputFormat} is specified as "SHAPEFILE", the name of the output
shapefile in quotes (e.g. "MyPoints") must be provided.}

\item{Buffer}{Radius in nautical miles by which to expand the points. Can be specified for
each point (as a numeric vector).}

\item{Clip}{if set to TRUE, polygon parts (from buffered points) that fall on land are removed (see \link{Clip2Coast}).}

\item{SeparateBuf}{If set to FALSE when adding a \code{Buffer},
all spatial objects are merged, resulting in a single spatial object.}

\item{NamesIn}{character vector of length 2 specifying the column names of Latitude and Longitude fields in
the \code{Input}. \strong{Latitudes name must be given first, e.g.:

\code{NamesIn=c('MyLatitudes','MyLongitudes')}}.}
}
\value{
Spatial object in your environment or ESRI shapefile in your working directory.
Data within the resulting spatial object contains the data provided in the \code{Input} plus
additional "x" and "y" columns which corresponds to the projected points locations 
and may be used to label points (see examples).

To see the data contained in your spatial object, type: \code{View(MyPoints@data)}.
}
\description{
Create Points to display point locations. Buffering points may be used to produce bubble charts.
}
\examples{
\donttest{


#Example 1: Simple points with labels

MyPoints=create_Points(Input=PointData)
plot(MyPoints)
text(MyPoints$x,MyPoints$y,MyPoints$name,adj=c(0.5,-0.5),xpd=TRUE)

#Example 2: Simple points with labels, highlighting one group of points with the same name

MyPoints=create_Points(Input=PointData)
plot(MyPoints)
text(MyPoints$x,MyPoints$y,MyPoints$name,adj=c(0.5,-0.5),xpd=TRUE)
plot(MyPoints[MyPoints$name=='four',],bg='red',pch=21,cex=1.5,add=TRUE)

#Example 3: Buffered points with radius proportional to catch

MyPoints=create_Points(Input=PointData,Buffer=0.5*PointData$Catch)
plot(MyPoints,col='green')
text(MyPoints$x,MyPoints$y,MyPoints$name,adj=c(0.5,0.5),xpd=TRUE)

#Example 4: Buffered points with radius proportional to catch and clipped to the Coast

MyPoints=create_Points(Input=PointData,Buffer=2*PointData$Catch,Clip=TRUE)
plot(MyPoints,col='cyan')
plot(Coast[Coast$ID=='All',],add=TRUE,col='grey')


}

}
\seealso{
\code{\link{create_Lines}}, \code{\link{create_Polys}}, \code{\link{create_PolyGrids}},
\code{\link{create_Stations}}, \code{\link{add_RefGrid}}.
}
