% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CCAMLRGIS-package.R
\docType{package}
\name{CCAMLRGIS-package}
\alias{CCAMLRGIS}
\alias{CCAMLRGIS-package}
\title{Loads and creates spatial data, including layers and tools that are relevant to CCAMLR activities.
All operations use the Lambert azimuthal equal-area projection (via EPSG:6932).}
\description{
This package provides two broad categories of functions: load functions and create functions.
}
\section{Load functions}{

Load functions are used to import CCAMLR geo-referenced layers and include:
\itemize{
  \item \link{load_ASDs}
  \item \link{load_SSRUs}
  \item \link{load_RBs}
  \item \link{load_SSMUs}
  \item \link{load_MAs}
  \item \link{load_Coastline}
  \item \link{load_MPAs}
  \item \link{load_EEZs}
  \item \link{load_Bathy}
}
}

\section{Create functions}{

Create functions are used to create geo-referenced layers from user-generated data and include:
\itemize{
  \item \link{create_Points}
  \item \link{create_Lines}
  \item \link{create_Polys}
  \item \link{create_PolyGrids}
  \item \link{create_Stations}
  \item \link{create_Pies}
  \item \link{create_Arrow}
}
}

\section{Vignette}{

To learn more about CCAMLRGIS, start with the GitHub ReadMe (see \url{https://github.com/ccamlr/CCAMLRGIS#table-of-contents}).
}

\seealso{
The CCAMLRGIS package relies on several other package which users may want to familiarize themselves with,
namely sf (\url{https://CRAN.R-project.org/package=sf}) and 
terra (\url{https://CRAN.R-project.org/package=terra}).
}
\author{
\strong{Maintainer}: Stephane Thanassekos \email{stephane.thanassekos@ccamlr.org}

Authors:
\itemize{
  \item Keith Reid
  \item Lucy Robinson
}

Other contributors:
\itemize{
  \item Michael D. Sumner [contributor]
  \item Roger Bivand [contributor]
}

}
\keyword{internal}
