% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_col.R
\name{add_col}
\alias{add_col}
\title{Add colors}
\usage{
add_col(var, cuts = 100, cols = c("green", "yellow", "red"))
}
\arguments{
\item{var}{numeric vector of the variable to be colorized. Either all values (in which case all
values will be assigned to a color) or only two values (in which case these are considered to be
the range of values).}

\item{cuts}{numeric, controls color classes. Either one value (in which case \code{n=cuts} equally
spaced color classes are generated) or a vector (in which case irregular color classes are
generated e.g.: \code{c(-10,0,100,2000)}).}

\item{cols}{character vector of colors (see R standard color names \href{http://www.stat.columbia.edu/~tzheng/files/Rcolor.pdf}{here}).
\code{cols} are interpolated along \code{cuts}. Color codes as those generated,
for example, by \code{\link[grDevices]{rgb}} may also be used.}
}
\value{
list containing the colors for the variable \code{var} (given as \code{$varcol} in the output) as
well as the single \code{cols} and \code{cuts}, to be used as inputs in \code{\link{add_Cscale}}.
}
\description{
Given an input variable, generates either a continuous color gradient or color classes.
To be used in conjunction with \code{\link{add_Cscale}}.
}
\examples{

# For more examples, see:
# https://github.com/ccamlr/CCAMLRGIS#52-adding-colors-to-data

MyPoints=create_Points(PointData)
MyCols=add_col(MyPoints$Nfishes)
plot(st_geometry(MyPoints),pch=21,bg=MyCols$varcol,cex=2)


}
\seealso{
\code{\link{add_Cscale}}, \code{\link{create_PolyGrids}}, \href{http://www.stat.columbia.edu/~tzheng/files/Rcolor.pdf}{R colors}.
}
