% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{load_Coastline}
\alias{load_Coastline}
\title{Load the full CCAMLR Coastline}
\usage{
load_Coastline()
}
\description{
Download the up-to-date spatial layer from the online CCAMLRGIS (\url{http://gis.ccamlr.org/}) and load it to your environment.
See examples for offline use. All layers use the Lambert azimuthal equal-area projection
 (\code{\link{CCAMLRp}})
Note that this coastline expands further north than \link{Coast}.
}
\examples{
 
\donttest{

#When online:
Coastline=load_Coastline()
plot(st_geometry(Coastline))

#For offline use, see:
#https://github.com/ccamlr/CCAMLRGIS#32-offline-use

}

}
\seealso{
\code{\link{load_ASDs}}, \code{\link{load_SSRUs}}, \code{\link{load_RBs}},
\code{\link{load_SSMUs}}, \code{\link{load_MAs}},
\code{\link{load_MPAs}}, \code{\link{load_EEZs}}.
}
