% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CCAMLRGIS_DataDescription.R
\docType{data}
\name{PieData2}
\alias{PieData2}
\title{Example dataset for create_Pies}
\format{
data.frame
}
\usage{
data(PieData2)
}
\description{
To be used in conjunction with \link{create_Pies}. Count and catch of species per location.
}
\examples{
#View(PieData2)

MyPies=create_Pies(Input=PieData2,
                  NamesIn=c("Lat","Lon","Sp","N"),
                  Size=5,
                  GridKm=250
)
#Plot Pies
plot(st_geometry(MyPies),col=MyPies$col)
#Add Pies legend
add_PieLegend(Pies=MyPies,PosX=-0.8,PosY=-0.3,Boxexp=c(0.5,0.45,0.12,0.45),
             PieTitle="Species")

}
\seealso{
\code{\link{create_Pies}}.
}
