% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Clip2Coast.R
\name{Clip2Coast}
\alias{Clip2Coast}
\title{Clip Polygons to a simplified Antarctic coastline}
\usage{
Clip2Coast(Input)
}
\arguments{
\item{Input}{sf polygon(s) to be clipped.}
}
\value{
sf polygon carrying the same data as the \code{Input}.
}
\description{
Clip Polygons to the \link{Coast} (removes polygon parts that fall on land) and computes the area of the resulting polygon.
Uses an sf object as input which may be user-generated or created via buffered points (see \link{create_Points}),
buffered lines (see \link{create_Lines}) or polygons (see \link{create_Polys}). N.B.: this function uses a
simplified coastline. For more accurate results, load the high resolution coastline (see \link{load_Coastline}), and
use sf::st_difference().
}
\examples{

MyPolys=create_Polys(PolyData,Densify=TRUE,Buffer=c(10,-15,120))
plot(st_geometry(MyPolys),col='red')
plot(st_geometry(Coast[Coast$ID=='All',]),add=TRUE)
MyPolysClipped=Clip2Coast(MyPolys)
plot(st_geometry(MyPolysClipped),col='blue',add=TRUE)
#View(MyPolysClipped)


}
\seealso{
\link{Coast}, \code{\link{create_Points}}, \code{\link{create_Lines}}, \code{\link{create_Polys}},
\code{\link{create_PolyGrids}}.
}
