% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CDFtestingSuite.R
\name{CDFtestTrackx}
\alias{CDFtestTrackx}
\title{Test a single CDF implementation with one set of parameters.}
\usage{
CDFtestTrackx(funct, eps, data, range = range, gran, reps, samplesize,
  SmoothAll = FALSE, ExtraTests_CDF = list(), ExtraTests_PDF = list(),
  ...)
}
\arguments{
\item{funct}{The differentially-private CDF-generating function to be tested}

\item{eps}{Epsilon value for Differential privacy control}

\item{data}{A vector of the data (single variable to compute CDFs from)}

\item{range}{A vector length 2 containing user-specified min and max to
truncate the universe to}

\item{gran}{The smallest unit of measurement in the data (one [year] for a 
list of ages)}

\item{reps}{The number of times the combination of CDFfunction, dataset,
and epsilon will be tested}

\item{samplesize}{The specified sample size is randomly selected from each dataset
without replacement.}

\item{SmoothAll}{Applies L2 monotonicity post-processing to every DP-CDF}

\item{ExtraTests_CDF}{If a user wishes to add extra diagnostics, the proper 
syntax would be:   
\code{ExtraTests_CDF = list( functionName1 = function1, functionName2 = function2)}}

\item{ExtraTests_PDF}{See above}

\item{...}{Optionally add additional parameters. This is primarily used to allow automated
execution of varied diagnostic functions.}
}
\value{
A complete set of diagnostic results in the form of
      \code{...$allscores}, which holds out a row of output for each of \code{reps} results.
}
\description{
Applies diagnostic functions to a single dpCDF, and only 
  releases a complete set of diagnostic results (called within\code{CDFtest}
  in Data Collection mode --- e.g., when \code{Visualization = FALSE})
}
\examples{
CDFtestTrackx(badCDF, eps = .01, cdfstep = 0, data = rexp(10000,.4),
  range= c(1,10), gran = .1, reps = 20, samplesize = 10000)
}

