% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdm.R
\name{cdm_name}
\alias{cdm_name}
\title{Get the CDM name}
\usage{
cdm_name(cdm)
}
\arguments{
\item{cdm}{A cdm_reference object}
}
\value{
The name of the CDM as a character string
}
\description{
Extract the CDM name attribute from a cdm_reference object
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
}
\examples{
\dontrun{
library(CDMConnector)
con <- DBI::dbConnect(duckdb::duckdb(), eunomiaDir())
cdm <- cdmFromCon(con, cdmSchema = "main", writeSchema = "main")
cdmName(cdm)
#> [1] "eunomia"

DBI::dbDisconnect(con, shutdown = TRUE)
}
}
