% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SART.R
\name{summary.SARTML}
\alias{summary.SARTML}
\alias{print.summary.SARTML}
\alias{print.SARTML}
\alias{print.summary.SARTMLs}
\title{Summarize SART Model}
\usage{
\method{summary}{SARTML}(object, Glist, data, ...)

\method{print}{summary.SARTML}(x, ...)

\method{print}{SARTML}(x, ...)

\method{print}{summary.SARTMLs}(x, ...)
}
\arguments{
\item{object}{an object of class \code{SARTML}, output of the function \code{\link{SARTML}}.}

\item{Glist}{the adjacency matrix or list sub-adjacency matrix. If missing make, sure that
the object provided to the function \code{\link{SARTML}} is available in \code{.GlobalEnv} (see detail - codedata section of \code{\link{SARTML}}).}

\item{data}{dataframe containing the explanatory variables. If missing make, sure that
the object provided to the function \code{\link{SARTML}} is available in \code{.GlobalEnv} (see detail - codedata section of \code{\link{SARTML}}).}

\item{...}{further arguments passed to or from other methods.}

\item{x}{an object of class \code{summary.SARTML}, output of the function \code{\link{summary.SARTML}}
or class \code{SARTML}, output of the function \code{\link{SARTML}}.}
}
\value{
A list consisting of:
\item{M}{number of sub-networks.}
\item{n}{number of individuals in each network.}
\item{estimate}{Maximum Likelihood (ML) estimator.}
\item{likelihood}{likelihood value.}
\item{cov}{covariance matrix of the estimate.}
\item{optimization}{output as returned by the optimizer.}
\item{codedata}{list of formula, name of the object \code{Glist}, number of friends in the network, name of the object \code{data},
and number of zeros in \code{y}.}
}
\description{
Summary and print methods for the class \code{SARTML} as returned by the function \link{SARTML}.
}
