% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_trans_matrix.R
\name{prepare_trans_matrix}
\alias{prepare_trans_matrix}
\title{Title
This function embeds the all-cause mortality probabilities in the transition matrices}
\usage{
prepare_trans_matrix(trans_matrix_array, prob_of_dying_vector_array,
  cycle_length)
}
\arguments{
\item{trans_matrix_array}{transition matrices without the all-cause mortality probabilities}

\item{prob_of_dying_vector_array}{table containing the all-cause mortality probabilities}

\item{cycle_length}{cycle length in years}
}
\value{
trans_matrix_array
}
\description{
Title
This function embeds the all-cause mortality probabilities in the transition matrices
}
\examples{
prob_vec<-extract_prob(initial_age=45,selected_country='Ethiopia',time_horizon=NULL,
gender = 'Female',selected_year=2015,cycle_length = (1/12),prob_data = sample_data)

drug_arm_5_years<-matrix(data = c(0,0.029,0.087*0.59,0,0,0.1,0,0.261*0.59,
0,0,0,0,0,0.325,0,0,0,0,1,0,0,0,0,0,1),nrow = 5,ncol = 5,byrow = TRUE)

both_arms_after_20_years<-matrix(data = c(0,0,0,0,0,0.1,0,0.261,0,0,0,0,
0,0.325,0,0,0,0,1,0,0,0,0,0,1),nrow = 5,ncol = 5,byrow = TRUE)

after_5_years_drug_arm_no_drug_arm_5<-matrix(data = c(0,0.029,0.087,0,0,
0.1,0,0.261,0,0,0,0,0,0.325,0,0,0,0,1,0,0,0,0,0,1),nrow = 5,ncol = 5,byrow = TRUE)

drug_arm_5_years<-change_current_prob_to_cycle_prob(drug_arm_5_years,1,(1/12))
both_arms_after_20_years<-change_current_prob_to_cycle_prob(both_arms_after_20_years,1,(1/12))

drug_arm<-array(c(replicate(n=5*12,drug_arm_5_years),replicate(n=15*12,
after_5_years_drug_arm_no_drug_arm_5),replicate(n=40*12,
both_arms_after_20_years)),dim = c(5,5,60*12))

up_mat<-prepare_trans_matrix(drug_arm,prob_vec,(1/12))
}
