% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CEDA.R
\name{runLimma}
\alias{runLimma}
\title{Modeling CRISPR screen data by R package limma}
\usage{
runLimma(data, design, contrast.matrix)
}
\arguments{
\item{data}{A numeric matrix containing log2 expression levels of sgRNAs
with rows corresponding to sgRNAs and columns corresponding to samples.}

\item{design}{A design matrix with rows corresponding to samples and
columns corresponding to coefficients to be estimated.}

\item{contrast.matrix}{A matrix with columns corresponding to contrasts.}
}
\value{
A data frame with rows corresponding to sgRNAs and columns
  corresponding to limma results
}
\description{
The lmFit function in R package limma is employed for group comparisons.
}
\examples{
y <- matrix(rnorm(1000*6),1000,6)
condition <- gl(2,3,labels=c("Treatment","Baseline"))
design <- model.matrix(~ 0 + condition)
contrast.matrix <- makeContrasts("conditionTreatment-conditionBaseline",levels=design)
limma.fit <- runLimma(y,design,contrast.matrix)

}
