% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/database.R
\name{upload_events}
\alias{upload_events}
\title{Upload Event Data}
\usage{
upload_events(
  uri_fun,
  user,
  password,
  host,
  port,
  database,
  patient_ids,
  event_dates
)
}
\arguments{
\item{uri_fun}{Uniform resource identifier (URI) string generating function for MongoDB credentials.}

\item{user}{MongoDB user name.}

\item{password}{MongoDB user password.}

\item{host}{MongoDB host server.}

\item{port}{MongoDB port.}

\item{database}{MongoDB database name.}

\item{patient_ids}{Vector of patient ID's.}

\item{event_dates}{Vector of clinical event dates.}
}
\value{
{
Objects of class character, reporting on completed event uploads.
}
}
\description{
Uploads event dates for patients already in the patient list. Useful when some events have already been documented before runnning CEDARS, for example as a second-line method to catch events missed with a different approach. Only event dates for existing records are altered, missing patient records are not added!
}
\examples{
\dontrun{
upload_events(uri_fun = mongo_uri_standard, user = 'John', password = 'db_password_1234',
host = 'server1234', port = NA, database = 'TEST_PROJECT', patient_ids = ids, event_dates = events)
}
}
