% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/optimizer.R
\name{optim2Opt}
\alias{optim2Opt}
\title{Two-Opt}
\usage{
optim2Opt(par = NULL, fun, creationFunction, control = list())
}
\arguments{
\item{par}{start solution of the local search}

\item{fun}{function that determines cost or length of a route/permutation}

\item{creationFunction}{Function to create individuals/solutions in search space}

\item{control}{(list), with the options\cr
\code{budget} The limit on number of target function evaluations (stopping criterion) (default: 100)
\code{vectorized} Boolean. Defines whether target function is vectorized (takes a list of solutions as argument) or not (takes single solution as argument). Default: FALSE\cr}
}
\value{
a list:\cr
\code{xbest} best solution found\cr
\code{ybest} fitness of the best solution\cr
\code{count} number of performed target function evaluations
}
\description{
Implementation of a Two-Opt local search.
}
\examples{
seed=0
glgseed=1
#distance
dF <- distancePermutationHamming
#mutation
mF <- mutationPermutationSwap
#recombination
rF <-  recombinationPermutationCycleCrossover
#creation
cF <- function()sample(5)
#objective function
lF <- landscapeGeneratorUNI(ref=1:5,distFun=dF)
#start optimization
set.seed(seed)
res <- optim2Opt(,lF,cF,list(budget=100))
res
}
\references{
Wikipedia contributors. "2-opt." Wikipedia, The Free Encyclopedia. Wikipedia, The Free Encyclopedia, 13 Jun. 2014. Web. 21 Oct. 2014. (http://en.wikipedia.org/wiki/2-opt)
}

