% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indefiniteLearning.R
\name{repairConditionsDistanceMatrix}
\alias{repairConditionsDistanceMatrix}
\title{Repair Conditions of a Distance Matrix}
\usage{
repairConditionsDistanceMatrix(mat)
}
\arguments{
\item{mat}{symmetric, CNSD distance matrix. If your matrix is not CNSD, use \code{\link{correctionCNSD}} first. Or use \code{\link{correctionDistanceMatrix}}.}
}
\value{
repaired distance matrix
}
\description{
This function repairs distance matrices, so that the following two properties are ensured:
The distance values should be non-zero and the diagonal should be zero.
Other properties (conditionally negative semi-definitene (CNSD), symmetric) are
assumed to be given.
}
\examples{
x <- list(c(2,1,4,3),c(2,4,3,1),c(4,2,1,3),c(4,3,2,1),c(1,4,3,2))
D <- distanceMatrix(x,distancePermutationInsert)
D <- correctionCNSD(D)
D
D <- repairConditionsDistanceMatrix(D)
D
}
\references{
Martin Zaefferer and Thomas Bartz-Beielstein. (2016). Efficient Global Optimization with Indefinite Kernels. Parallel Problem Solving from Nature-PPSN XIV. Accepted, in press. Springer.
}
\seealso{
\code{\link{correctionDefinite}}, \code{\link{correctionDistanceMatrix}}, \code{\link{correctionKernelMatrix}}, \code{\link{correctionCNSD}}, \code{\link{repairConditionsCorrelationMatrix}}
}
