% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indefiniteLearning.R
\name{correctionCNSD}
\alias{correctionCNSD}
\title{Correcting Conditional Negative Semi-Definiteness}
\usage{
correctionCNSD(mat, method = "flip", tol = 1e-08)
}
\arguments{
\item{mat}{symmetric matrix, which should be at least of size 3x3}

\item{method}{string that specifies method for correction: spectrum clip \code{"clip"}, spectrum flip \code{"flip"}, nearest definite matrix \code{"near"}, spectrum square\code{"square"}, spectrum diffusion \code{"diffusion"}.}

\item{tol}{torelance value. Eigenvalues between \code{-tol} and \code{tol} are assumed to be zero.}
}
\value{
the corrected CNSD matrix
}
\description{
Correcting, e.g., a distance matrix with chosen methods so that it becomes a CNSD matrix.
}
\examples{
x <- list(c(2,1,4,3),c(2,4,3,1),c(4,2,1,3),c(4,3,2,1),c(1,4,3,2))
D <- distanceMatrix(x,distancePermutationInsert)
is.CNSD(D) #matrix should not be CNSD
D <- correctionCNSD(D)
is.CNSD(D) #matrix should now be CNSD
D
# note: to fix the negative distances, use repairConditionsDistanceMatrix. 
# Or else, use correctionDistanceMatrix.
}
\references{
Martin Zaefferer and Thomas Bartz-Beielstein. (2016). Efficient Global Optimization with Indefinite Kernels. Parallel Problem Solving from Nature-PPSN XIV. Accepted, in press. Springer.
}
\seealso{
\code{\link{modelKriging}}
}
