% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFtime.R
\name{CFcalendar}
\alias{CFcalendar}
\alias{CFproperties}
\alias{CFunit}
\alias{CForigin}
\alias{CFoffsets}
\title{Properties of a CFtime object}
\usage{
CFcalendar(cf)

CFunit(cf)

CForigin(cf)

CFoffsets(cf)
}
\arguments{
\item{cf}{CFtime. An instance of \code{CFtime}.}
}
\value{
\code{CFcalendar()} and \code{CFunit()} return an atomic character string.
\code{CForigin()} returns a data frame of timestamp elements with a single row of
data. \code{CFoffsets()} returns a vector of offsets or \code{NULL} if no offsets have
been set.
}
\description{
These functions return the properties of an instance of the \code{CFtime} class.
The properties are all read-only, but offsets can be added using the \code{+}
operator.
}
\section{Functions}{
\itemize{
\item \code{CFcalendar()}: The calendar of the CFtime instance

\item \code{CFunit()}: The unit of the CFtime instance

\item \code{CForigin()}: The origin of the CFtime instance in timestamp elements

\item \code{CFoffsets()}: The offsets of the CFtime instance as a vector

}}
\examples{
cf <- CFtime("days since 1850-01-01", "julian", 0:364)
CFcalendar(cf)
CFunit(cf)
CForigin(cf)
CFoffsets(cf)
}
