% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot2WayANOVA.R
\name{Plot2WayANOVA}
\alias{Plot2WayANOVA}
\title{Plot a 2 Way ANOVA using dplyr and ggplot2}
\usage{
Plot2WayANOVA(formula,
               dataframe = NULL,
               confidence=.95,
               plottype = "line",
               errorbar.display = "CI",
               xlab = NULL,
               ylab = NULL,
               title = NULL,
               subtitle = NULL,
               interact.line.size = 2,
               ci.line.size = 1,
               mean.label = FALSE,
               mean.ci = TRUE,
               mean.size = 4,
               mean.shape = 23,
               mean.color = "darkred",
               mean.label.size = 3,
               mean.label.color = "black",
               offset.style = "none",
               overlay.type = NULL,
               posthoc.method = "scheffe",
               show.dots = FALSE,
               PlotSave = FALSE,
               ggtheme = ggplot2::theme_bw(),
               package = "RColorBrewer",
               palette = "Dark2",
               ggplot.component = NULL)
}
\arguments{
\item{formula}{a formula with a numeric dependent (outcome) variable,
and two independent (predictor) variables e.g. \code{mpg ~ am * vs}.
The independent variables are coerced to factors (with warning) if
possible.}

\item{dataframe}{a dataframe or an object that can be coerced to a dataframe}

\item{confidence}{what confidence level for confidence intervals}

\item{plottype}{bar or line (quoted)}

\item{errorbar.display}{default "CI" (confidence interval), which type of
errorbar should be displayed around the mean point? Other options
include "SEM" (standard error of the mean) and "SD" (standard dev).}

\item{xlab, ylab}{Labels for `x` and `y` axis variables. If `NULL` (default),
variable names for `x` and `y` will be used.}

\item{title}{The text for the plot title. A generic default is provided.}

\item{subtitle}{The text for the plot subtitle. If `NULL` (default), key
model information is provided as a subtitle.}

\item{interact.line.size}{Line size for the line connecting the group means
(Default: `2`).}

\item{ci.line.size}{Line size for the confidence interval bracketing
the group means (Default: `1`).}

\item{mean.label}{Logical that decides whether the value of the group
mean is to be displayed (Default: `FALSE`).}

\item{mean.ci}{Logical that decides whether the confidence interval for
group means is to be displayed (Default: `TRUE`).}

\item{mean.size}{Point size for the data point corresponding to mean
(Default: `4`).}

\item{mean.shape}{Shape of the plot symbol for the mean
(Default: `23` which is a diamond).}

\item{mean.color}{Color for the data point corresponding to mean (Default:
`"darkred"`).}

\item{mean.label.size, mean.label.color}{Aesthetics for
the label displaying mean. Defaults: `3`, `"black"`, respectively.}

\item{offset.style}{A character string (e.g., `"wide"` or `"narrow"`,
or `"none"`) which controls whether items are offset from the
centerline for clarity. Useful when you want to add individual
datapoints or confdence interval lines overlap. (Default: `"none"`).}

\item{overlay.type}{A character string (e.g., `"box"` or `"violin"`),
if you wish to overlay that information on factor1}

\item{posthoc.method}{A character string, one of "hsd", "bonf", "lsd",
"scheffe", "newmankeuls", defining the method for the pairwise comparisons.
(Default: `"scheffe"`).}

\item{show.dots}{Logical that decides whether the individual data points
are displayed (Default: `FALSE`).}

\item{PlotSave}{a logical indicating whether the user wants to save the plot
as a png file}

\item{ggtheme}{A function, ggplot2 theme name. Default value is ggplot2::theme_bw().
Any of the ggplot2 themes, or themes from extension packages are allowed (e.g.,
hrbrthemes::theme_ipsum(), etc.).}

\item{package}{Name of package from which the palette is desired as string
or symbol.}

\item{palette}{Name of palette as string or symbol.}

\item{ggplot.component}{A ggplot component to be added to the plot prepared.
The default is NULL. The argument should be entered as a function.
for example to change the size and color of the x axis text you use:
`ggplot.component = theme(axis.text.x = element_text(size=13, color="darkred"))`
depending on what theme is in use the ggplot component might not work as expected.}
}
\value{
A list with 5 elements which is returned invisibly. These items
  are always sent to the console for display but for user convenience
  the function also returns a named list with the following items
  in case the user desires to save them or further process them -
  \code{$ANOVATable}, \code{$ModelSummary}, \code{$MeansTable},
  \code{$PosthocTable}, \code{$BFTest}, and \code{$SWTest}.
  The plot is always sent to the default plot device
}
\description{
Takes a formula and a dataframe as input, conducts an analysis of variance
prints the results (AOV summary table, table of overall model information
and table of means) then uses ggplot2 to plot an interaction graph (line
or bar) .  Also uses Brown-Forsythe test for homogeneity of
variance.  Users can also choose to save the plot out as a png file.
}
\details{
Details about how the function works in order of steps taken.
\enumerate{
\item Some basic error checking to ensure a valid formula and dataframe.
  Only accepts fully *crossed* formula to check for interaction term
\item Ensure the dependent (outcome) variable is numeric and that the two
  independent (predictor) variables are or can be coerced to factors -- user
  warned on the console
\item Remove missing cases -- user warned on the console
\item Calculate a summarized table of means, sds, standard errors of the
   means, confidence intervals, and group sizes.
\item Use \code{\link[stats]{aov}} function to execute an Analysis of
  Variance (ANOVA)
\item Use \code{sjstats::anova_stats} to calculate eta squared
  and omega squared values per factor. If the design is unbalanced warn
  the user and use Type II sums of squares
\item Produce a standard ANOVA table with additional columns
\item Use the \code{\link[DescTools]{PostHocTest}} for producing a table
  of post hoc comparisons for all effects that were significant
\item Use the \code{\link[car]{leveneTest}} for testing Homogeneity
  of Variance assumption with Brown-Forsythe
\item Use the \code{\link[DescTools]{PostHocTest}} for conducting
  post hoc tests for effects that were significant
\item Use the \code{\link[stats]{shapiro.test}} for testing normality
  assumption with Shapiro-Wilk
\item Use \code{ggplot2} to plot an interaction plot of the type the
  user specified.}
The defaults are deliberately constructed to emphasize the nature
  of the interaction rather than focusing on distributions. So
  while a violin plot of the first factor by level is displayed
  along with dots for individual data points shaded by the second
  factor, the emphasis is on the interaction lines.
}
\examples{

Plot2WayANOVA(mpg ~ am * cyl, mtcars, plottype = "line")
Plot2WayANOVA(mpg ~ am * cyl,
  mtcars,
  plottype = "line",
  overlay.type = "box",
  mean.label = TRUE
)

library(ggplot2)
Plot2WayANOVA(mpg ~ am * vs, 
  mtcars, 
  confidence = .99,
  ggplot.component = theme(axis.text.x = element_text(size=13, color="darkred")))
  
}
\references{
: ANOVA: Delacre, Leys, Mora, & Lakens, *PsyArXiv*, 2018
}
\seealso{
\code{\link[stats]{aov}}, \code{\link[car]{leveneTest}},
\code{sjstats::anova_stats}, \code{\link[stats]{replications}},
\code{\link[stats]{shapiro.test}}
}
\author{
Chuck Powell
}
