\name{getPara.sAGP}
\alias{getPara.sAGP}
\title{
Initialize parameters for sAGP estimation.
}
\description{
This function sets the default values of parameters required to run sAGP estimation.
}
\usage{
getPara.sAGP()
}
\value{
The default parameters obtained from this function is essential to run \code{getsAGP()}. These parameters include:
\item{inputdata}{full path to input data file generated by \code{getSeg()} or in the same format}
\item{savedata}{name of the output plain text file to be saved}
\item{pngdir}{directory to save BAF-LRR plots, ignored if is.png is FALSE}
\item{purityfile}{AGP estimation file returned by \code{getAGP()}}
\item{BAFfilter}{DNA segments with BAF markers below this value are removed to reduce noise. Default 10}
\item{thr.kmeans}{convergence threshold for \code{getKmeans()}. Default 0.1}
\item{thr.originsize}{minimum number of markers included in the origin cluster, used by \code{getOrigin()}. Default 500}
\item{thr.penalty}{penalty (in units of number of markers) to increase ploidy. Default 500}
\item{std.BAF}{standard deviation of BAF markers. Default 0.025}
\item{std.LRR}{standard deviation of LRR markers. Default 0.1}
\item{is.normalize}{if data needs to be normalized first. Default TRUE}
\item{LRR_correction_del}{factor to correct negative LRR values. Default 0.572}
\item{LRR_correction_amp}{factor to correct positive LRR values. Default 0.553}
\item{K}{constant parameter for objective function F (see details in \code{getSegPurity()}). Default 12}
\item{is.plot}{if TRUE, the process of estimating sAGP value for each data point will be shown on a prompted BAF-LRR plot. Default FALSE}
\item{max.cn}{maximum copy number examined. Default ploidy+4}
\item{strictness}{maximum sAGP value considered during optimization. By allowing it to be larger than 1, small noise around 1 could be tolerated. Default 1.1}
\item{is.multicore}{if to use multiple thread to increase computational speed. Default FALSE. If TRUE, R package 'multicore' is required. Currently this option is not available for Windows system.}
}
\author{
Bo Li
}
\examples{
para.s=getPara.sAGP()
## Increase strictness
para.s$strictness=1
\dontrun{
## Use multi-thread computing
install.packages('multicore')
library(multicore)
para.s$is.multicore=TRUE
}
}