% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.CICA.R
\name{summary.CICA}
\alias{summary.CICA}
\title{Summary method for class CICA}
\usage{
\method{summary}{CICA}(object, ...)
}
\arguments{
\item{object}{Object of the type produced by \code{\link{CICA}}}

\item{...}{Additional arguments}
}
\value{
\code{summary.CICA} returns an overview of the estimated clustering of a \code{\link{CICA}} analysis
\item{PM}{Partitioning matrix}
\item{tab}{tabulation of the clustering}
\item{Loss}{Loss function value of the solution}
}
\description{
Summarize a CICA analysis
}
\examples{
data('ExampleData', package = 'CICA')
output <- CICA(DataList = ExampleData, nStarts = 3, nComp = 5, nClus = 3, verbose = FALSE)
summary(output)
}
