% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialClustering.R
\name{initialClustering}
\alias{initialClustering}
\title{Initial Clustering}
\usage{
initialClustering(
  seu,
  batch.var = "Batch",
  cut.height = 0.4,
  nfeatures = 2000,
  additional.vars.to.regress = NULL,
  dims = seq_len(14),
  resolution = 0.6,
  downsampling.size = 50,
  verbose = FALSE
)
}
\arguments{
\item{seu}{A Seurat object. Required.}

\item{batch.var}{Character string specifying one of the column names in \code{seu@meta.data} 
used to partition the object into subsets. Default is "Batch".}

\item{cut.height}{Numeric value specifying the height at which to cut hierarchical trees. Default is 0.4.}

\item{nfeatures}{Numeric value indicating the number of high-variance genes to use. Default is 2000.}

\item{additional.vars.to.regress}{Character vector of additional variable names from \code{seu@meta.data} to regress out. 
Optional. Default is \code{NULL}.}

\item{dims}{Numeric vector specifying the dimensions to be used for clustering (passed to Seurat). Default is 1:14.}

\item{resolution}{Numeric value for clustering resolution (passed to Seurat). Default is 0.6.}

\item{downsampling.size}{Numeric value indicating the number of cells representing each group. Default is 40.}

\item{verbose}{Logical. If \code{TRUE}, a progress bar is displayed. Default is \code{FALSE}.}
}
\value{
A Seurat S4 object with initial cluster assignments stored in the \code{initial_cluster} column of its \code{meta.data}.
}
\description{
Perform batch-specific initial clustering on a Seurat object.
}
\seealso{
\code{\link{getIDEr}}, \code{\link{finalClustering}}
}
