% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatterPlot.R
\name{scatterPlot}
\alias{scatterPlot}
\title{Scatterplot by a selected feature}
\usage{
scatterPlot(
  seu,
  reduction,
  colour.by,
  colvec = NULL,
  title = NULL,
  sort.by.numbers = TRUE,
  viridis_option = "B"
)
}
\arguments{
\item{seu}{Seurat S4 object after the step of \code{getIDER}. Required.}

\item{reduction}{Character. The dimension reduction used to plot. Common
options: \code{"pca"}, \code{"tsne"}, \code{"umap"}. The availability of dimension reduction
can be checked by \code{Reductions(seu)}.}

\item{colour.by}{Character. One of the column names of \code{seu@meta.data}.
Can be either discreet or continuous variables.}

\item{colvec}{A vector of Hex colour codes. If no value is given (default),
a vector of 74 colours will be used.}

\item{title}{Character. Title of the figure.}

\item{sort.by.numbers}{Boolean. Whether to sort the groups by the number
of cells.(Default: \code{True})}

\item{viridis_option}{viridis_option. (Default: \code{B})}
}
\value{
A ggplot2 scatter plot
}
\description{
Scatterplot of a Seurat object based on dimension reduction.
}
