% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sem_functions.R
\name{sem_appl}
\alias{sem_appl}
\title{Structural equation modeling approach}
\usage{
sem_appl(Y = NULL, X = NULL, K = NULL, L = NULL)
}
\arguments{
\item{Y}{Numeric input vector for the primary outcome.}

\item{X}{Numeric input vector for the exposure variable.}

\item{K}{Numeric input vector for the intermediate outcome.}

\item{L}{Numeric input vector for the observed confounding factor.}
}
\value{
Returns a list with point estimates of the parameters
        (\code{point_estimates}), standard error estimates
        (\code{SE_estimates}) and p-values from large-sample
        Wald-type tests (\code{pvalues}).
}
\description{
Function which uses the \code{\link[lavaan]{sem}} function in the
\code{lavaan} package to fit the model
\deqn{L = \alpha_0 + \alpha_1 \cdot X + \epsilon_1, \epsilon_1 \sim N(0,\sigma_1^2)}{L = \alpha0 + \alpha1*X + \epsilon1, \epsilon1 ~ N(0,\sigma1^2)}
\deqn{K = \alpha_2 + \alpha_3 \cdot X + \alpha_4 \cdot L + \epsilon_2, \epsilon_2 \sim~ N(0,\sigma_2^2)}{K = \alpha2 + \alpha3*X + \alpha4*L + \epsilon2, \epsilon2 ~ N(0,\sigma2^2)}
\deqn{Y = \alpha_5 + \alpha_6 \cdot K + \alpha_{XY} \cdot X + \epsilon_3, \epsilon_3 \sim N(0,\sigma_3^2)}{Y = \alpha5 + \alpha6*K + \alphaXY*X + \epsilon3, \epsilon3 ~ N(0,\sigma3^2)}
in order to obtain point and standard error estimates
of the parameters
\eqn{\alpha_1, \alpha_3, \alpha_4, \alpha_6, \alpha_{XY}}{\alpha1, \alpha3, \alpha4, \alpha6, \alphaXY}
for the GLM setting.
See the vignette for more details.
}
\examples{

dat <- generate_data(setting = "GLM")
sem_appl(Y = dat$Y, X = dat$X, K = dat$K, L = dat$L)

}
