% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ce_estimate_bart_att.R
\name{ce_estimate_bart_att}
\alias{ce_estimate_bart_att}
\title{This function implements the BART method when estimand is ATT. Please use our main function ce_estimate.R.}
\usage{
ce_estimate_bart_att(
  y,
  x,
  w,
  discard = "No",
  ndpost = 1000,
  reference_trt,
  ...
)
}
\arguments{
\item{y}{a numeric vector (0, 1) representing a binary outcome}

\item{x}{a dataframe, including all the covariates but not treatments.}

\item{w}{a numeric vector representing the treatment groups}

\item{discard}{"No" or "Yes" indicating whether to use the discarding rules for the BART based method. The default is "No"}

\item{ndpost}{number of posterior samples from BART}

\item{reference_trt}{reference treatment group for ATT effect}

\item{...}{Other parameters that can be passed through the BART::pbart() function}
}
\value{
a list with w-1 elements for ATT effect; Each element of the list contains the estimation, standard error, lower and upper 95\% CI for RD/RR/OR
}
\description{
This function implements the BART method when estimand is ATT. Please use our main function ce_estimate.R.
}
\examples{
library(CIMTx)
lp_w_all <-
 c(".4*x1 + .1*x2  - .1*x4 + .1*x5",    # w = 1
   ".2 * x1 + .2 * x2  - .2 * x4 - .3 * x5")  # w = 2
nlp_w_all <-
 c("-.5*x1*x4  - .1*x2*x5", # w = 1
   "-.3*x1*x4 + .2*x2*x5")# w = 2
lp_y_all <- rep(".2*x1 + .3*x2 - .1*x3 - .1*x4 - .2*x5", 3)
nlp_y_all <- rep(".7*x1*x1  - .1*x2*x3", 3)
X_all <- c(
 "rnorm(300, 0, 0.5)",# x1
 "rbeta(300, 2, .4)",   # x2
 "runif(300, 0, 0.5)",# x3
 "rweibull(300,1,2)",  # x4
 "rbinom(300, 1, .4)"# x5
)
set.seed(111111)
data <- data_sim(
 sample_size = 300,
 n_trt = 3,
 X = X_all,
 lp_y = lp_y_all,
 nlp_y  = nlp_y_all,
 align = FALSE,
 lp_w = lp_w_all,
 nlp_w = nlp_w_all,
 tau = c(-1.5,0,1.5),
 delta = c(0.5,0.5),
 psi = 1
)
ce_estimate_bart_att(y = data$y, x = data$covariates , w = data$w, ndpost = 10,reference_trt=1)

}
