% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CINNA.R
\name{group_centrality}
\alias{group_centrality}
\title{Group Centrality}
\usage{
group_centrality(x, vids = V(x))
}
\arguments{
\item{x}{An igraph or a network object}

\item{vids}{Nodes to be considered in the calculation}
}
\value{
a vector including centrality values for each node
}
\description{
This function computes group Centrality. So, it considers a consistent ranking of
each node to be calculated such that scores diverse possible synergies among possible groups of vertices.
}
\examples{

data(zachary)

group_centrality(zachary)

}
\references{
Michalak, T.P., Aadithya, K.V., Szczepanski, P.L., Ravindran, B. and Jennings, N.R., 2013. Efficient computation of the Shapley value for game-theoretic network centrality. Journal of Artificial Intelligence Research, 46, pp.607-650.

https://www.civilica.com/Paper-IBIS07-IBIS07_127.html
}
\author{
Minoo Ashtiani, Mehdi Mirzaie, Mohieddin Jafari
}
