% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_copula.R
\name{generate_clayton_copula}
\alias{generate_clayton_copula}
\title{Generate data from the Clayton copula.}
\usage{
generate_clayton_copula(n = NULL, phi = NULL)
}
\arguments{
\item{n}{Sample size.}

\item{phi}{Integer specifying the value of the copula parameter \eqn{\phi} for
the dependence between the two generated phenotypes.}
}
\value{
A dataframe containing \code{n} observations of \eqn{Y_1}{Y1}, \eqn{Y_2}{Y2}.
}
\description{
Function to generate two quantitative phenotypes \eqn{Y_1}{Y1}, \eqn{Y_2}{Y2},
from the bivariate Clayton copula with standard normal
marginal distributions.
}
\examples{

dat1a <- generate_clayton_copula(n = 1000, phi = 0.5)
dat1b <- generate_clayton_copula(n = 1000, phi = 2)
dat1c <- generate_clayton_copula(n = 1000, phi = 8)
par(mfrow = c(3, 1))
plot(dat1a$Y1, dat1a$Y2, main="Clayton copula, tau = 0.2")
plot(dat1b$Y1, dat1b$Y2, main="Clayton copula, tau = 0.5")
plot(dat1c$Y1, dat1c$Y2, main="Clayton copula, tau = 0.8")

}
