% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/utilities.r
\name{model_terms_clme}
\alias{model_terms_clme}
\title{Create model matrices for \code{clme}}
\usage{
model_terms_clme(formula, data, ncon = 1)
}
\arguments{
\item{formula}{a formula defining a linear fixed or mixed effects model. The constrained effect(s) must come before any unconstrained covariates on the right-hand side of the expression. The first \code{ncon} terms will be assumed to be constrained.}

\item{data}{data frame containing the variables in the model.}

\item{ncon}{the number of variables in \code{formula} that are constrained.}
}
\value{
A list with the elements:
\tabular{rl}{
  Y       \tab response variable \cr
  X1      \tab design matrix for constrained effect \cr
  X2      \tab design matrix for covariates \cr
  P1      \tab number of constrained coefficients \cr
  U       \tab matrix of random effects \cr
  formula \tab the final formula call (automatically removes intercept) \cr
  dframe  \tab the dataframe containing the variables in the model \cr
  REidx   \tab an element to define random effect variance components \cr
  REnames \tab an element to define random effect variance components \cr
}
}
\description{
Parses formulas to creates model matrices for \code{clme}.
}
\note{
The first term on the right-hand side of the formula should be the fixed effect
with constrained coefficients. Random effects are represented with a vertical bar,
so for example the random effect \code{U} would be included by
\code{Y ~ X1 + (1|U)}.

The intercept is removed automatically. This is done to ensure that parameter
estimates are of the means of interest, rather than being expressed as a mean
with offsets.
}
\examples{
data( rat.blood )
model_terms_clme( mcv ~ time + temp + sex + (1|id) , data = rat.blood )
}
\seealso{
\code{\link{CLME-package}}
\code{\link{clme}}
}

