% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CLONETv2_check_ploidy_and_admixture.R
\name{check_ploidy_and_admixture}
\alias{check_ploidy_and_admixture}
\title{Function to compute ploidy from a beta table.}
\usage{
check_ploidy_and_admixture(beta_table, ploidy_table, admixture_table)
}
\arguments{
\item{beta_table}{data.frame formatted as the output of function
\code{\link[CLONETv2:compute_beta_table]{compute_beta_table}}}

\item{ploidy_table}{data.frame formatted as the output of function
\code{\link[CLONETv2:compute_ploidy]{compute_ploidy}}}

\item{admixture_table}{data.frame formatted as the output of function
\code{\link[CLONETv2:compute_dna_admixture]{compute_dna_admixture}}}
}
\value{
A ggplot2 plot reporting log2 on the x axis and beta and the y axis.
Each dot represents a segment of the input beta_table. Red transparent
circles corresponds to expected log2 vs beta position for different allele
specific copy number combinations given ploidy and admixture reported in
tables ploidy_table and admixture_table, respectively. Labels in the form
(cnA, cnB) indicate repsectively the major and minor allele copy number
value. Labels above the plot comprises sample name and ploddy/admixture estimates.
}
\description{
This function takes the beta table of a tumor sample and returns its ploidy.
}
\examples{

## check ploidy and admixture estimates
check_plot_toy <- check_ploidy_and_admixture(beta_table = bt_toy, ploidy_table = pl_table_toy,
  admixture_table = adm_table_toy)

}
\author{
Davide Prandi
}
