% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_doc_icecream.R
\docType{data}
\name{icecream}
\alias{icecream}
\title{Ice Cream data}
\format{
A data frame with 21 rows and three columns.
\describe{
\item{rank}{the rank of the ice cream within each judging block}
\item{judge}{the judge that was used}
\item{variety}{the type of ice cream that was tested}
}
}
\source{
Table 5.1 in Conover (1998, p. 391).
}
\usage{
data(icecream)
}
\description{
Ice Cream data
}
\details{
The icecream data set comes from a Balanced Incomplete Block Design. There
are seven vanilla ice-creams that are the same except for increasing amounts
of vanilla flavouring. Seven judges each taste three varieties.
}
\examples{
attach(icecream)
durbin(y = rank, groups = variety, blocks = judge)
}
\references{
Conover, W. J. (1998). Practical nonparametric statistics (3rd ed.). New York: Wiley.
Rayner, J.C.W and Livingston, G. C. (2022). An Introduction to Cochran-Mantel-Haenszel Testing and Nonparametric ANOVA. Wiley.
}
\keyword{BIBD}
\keyword{datasets}
\keyword{icecream}
