% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_cof_transformer_11kv.R
\name{f_cof_transformer_11kv}
\alias{f_cof_transformer_11kv}
\title{Financial Consequences of Failure for a 6.6/11 kV Transformer}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 1.1, 2017:
\url{https://www.ofgem.gov.uk/system/files/docs/2017/05/dno_common_network_asset_indices_methodology_v1.1.pdf}
}
\usage{
f_cof_transformer_11kv(kva = "Default", type = "Default")
}
\arguments{
\item{kva}{Numeric. The rated transformer capacity measured in kVA
for a 6.6/11 kV transformer. Rated capacity is used to derive the
type financial factor. For a general description of type financial factor see
section 7.3.3.1 on page 76 in CNAIM (2017). A setting of \code{"Default"}
will result in a type financial factor equal to 1
(cf. section D1.2.1, page 162, CNAIM, 2017).}

\item{type}{String. Relates to the accessibility of the transformer
Options: \code{type = c("Type A", "Type B", "Type C", "Default")}.
A setting of \code{"Type A"} - Normal access.
A setting of \code{"Type B"} - Constrained access or confined working space.
A setting of \code{"Type C"} - Underground substation.
A setting of \code{"Default"} - Normal access thus same as \code{"Type A"}
setting (cf. table 214, page 164, CNAIM, 2017).}
}
\value{
Numeric. Financial consequences of failure for a 6.6/11 kV transformer.
}
\description{
This function calculates financial consequences of failure
(cf. section 7.3, page 75, CNAIM, 2017). Financial consequences
of failure is used in
the derivation of consequences of failure see \code{\link{cof}}().
}
\examples{
# Financial consequences of failure for a 6.6/11 kV transformer
f_cof_transformer_11kv(kva = 700, type = "Default")
}
