% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expected_life.R
\name{expected_life}
\alias{expected_life}
\title{Expected Life}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 2.1, 2021:
\url{https://www.ofgem.gov.uk/sites/default/files/docs/2021/04/dno_common_network_asset_indices_methodology_v2.1_final_01-04-2021.pdf}
}
\usage{
expected_life(normal_expected_life, duty_factor, location_factor)
}
\arguments{
\item{normal_expected_life}{Numeric. The number of years a new asset is
expected to normally last. I.e. technical life time.
See page 107, table 20 in CNAIM (2021).}

\item{duty_factor}{Numeric. E.g. the output returned by the function
\code{\link{duty_factor_transformer_11_20kv}()}.}

\item{location_factor}{Numeric. The output returned by the function
\code{\link{location_factor}()}.}
}
\value{
Numeric. Expected life.
}
\description{
This function calculates the expected life of
an electric network asset measured in years
when it would be expected to first observe significant deterioration.
The expected life is derived based on the assets normal expected life,
 duty factor and location factor.
See section 6.1.4 on page 36 in CNAIM (2021).
}
\examples{
# An asset e.g. a transformer with an expcted life of 50 years
expected_life(normal_expected_life = 50,
              duty_factor = 1,
              location_factor = 1)

}
